/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class TrapdoorSpider implements IObject {

  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage[] trapdoors;
  private int x;
  private int y;
  private boolean updated;
  private int dying = -1;
  private int sleeping;
  private int shootDelay;

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.trapdoors = Main.trapdoors;
    this.x = x;
    this.y = y;

    sleeping = Main.random.nextInt(120);

    for(int i = 0; i < 4; i++) {
      for(int j = 0; j < 4; j++) {
        occupied[(y >> 5) + i - 1][(x >> 5) + j - 1] = true;
      }
    }

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
    updated = false;
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (updated) {
      return false;
    } else {
      updated = true;
    }

    if (dying > 0) {
      dying--;
      if (dying == 0) {
        int X = x >> 5;
        int Y = y >> 5;

        for(int i = 0; i < 4; i++) {
          for(int j = 0; j < 4; j++) {
            occupied[Y + i - 1][X + j - 1] = false;
          }
        }

        enemyList.remove(enemyIndex);
      }
      return false;
    }

    double dx = playerX - (x + 81);
    double dy = playerY - (y + 61);
    if (dx * dx + dy * dy < 4096) {
      sleeping = -1;
      Main.addHealth(-1);
    }

    if (--sleeping <= 0) {
      if (shootDelay == 0) {
        shootDelay = 5;
        bullets.add(new Bullet(x + 81, y + 61, playerX, playerY, 5));
      } else {
        shootDelay--;
      }
      if (sleeping < -30) {
        sleeping = 120;
      }

      if (playerBullet != null) {
        double bx = playerBullet.x - (x + 81);
        double by = playerBullet.y - (y + 61);
        if (bx * bx + by * by <= 1024) {
          dying = 15;
          return true;
        }
      }
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    if (dying > 10) {
      g.drawImage(trapdoors[2], x - cameraX, y - cameraY, null);
    } else if (dying > 0) {
      g.drawImage(trapdoors[3], x - cameraX, y - cameraY, null);
    } else if (sleeping > 0) {
      g.drawImage(trapdoors[0], x - cameraX, y - cameraY, null);
    } else {
      g.drawImage(trapdoors[1], x - cameraX, y - cameraY, null);
    }
  }
}
