/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class Stinger implements IObject {

  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage[] stinger;
  private int x;
  private int y;
  private double angle;
  private boolean updated;
  private int ejected;

  public Stinger(int direction) {
    switch(direction) {
      case 0:
        angle = 0;
        break;
      case 1:
        angle = -Math.PI / 2;
        break;
      case 2:
        angle = Math.PI;
        break;
      case 3:
        angle = -3 * Math.PI / 2;
        break;
    }
  }

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.stinger = Main.stinger;
    this.x = x;
    this.y = y;

    occupied[(y >> 5) - 1][(x >> 5) - 1] = true;
    occupied[(y >> 5) - 1][(x >> 5)] = true;
    occupied[(y >> 5)][(x >> 5) - 1] = true;
    occupied[(y >> 5)][(x >> 5)] = true;

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
    updated = false;
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (updated) {
      return false;
    } else {
      updated = true;
    }

    double dx = playerX - x;
    double dy = playerY - y;
    if (dx * dx + dy * dy < 1024) {
      Main.addHealth(-1);
      ejected++;
    } else if (ejected > 5) {
      ejected = 5;
    } else if (ejected > 0) {
      ejected--;
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    if (ejected > 5) {
      Main.drawSprite(g, angle, x - cameraX, y - cameraY,
          stinger[2]);
    } else if (ejected > 0) {
      Main.drawSprite(g, angle, x - cameraX, y - cameraY,
          stinger[1]);
    } else {
      Main.drawSprite(g, angle, x - cameraX, y - cameraY,
          stinger[0]);
    }
  }
}
