/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class Moth implements IObject {

  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage[] moths;
  private int x;
  private int y;
  private int shootDelay;
  private int dying = -1;

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.moths = Main.moths;
    this.x = x;
    this.y = y;

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (enemyList != Main.objects) {
      enemyList.remove(enemyIndex);
      Main.objects.add(this);
      enemyList = Main.objects;
      enemyIndex = enemyList.size() - 1;
    }

    if (dying > 0) {
      dying--;
      if (dying == 0) {
        enemyList.remove(enemyIndex);
      }
      return false;
    }

    if (playerBullet != null) {
      double bx = playerBullet.x - x;
      double by = playerBullet.y - y;
      if (bx * bx + by * by <= 2304) {
        dying = 15;
        return true;
      }
    }

    y += 6;
    if (y > playerY + 300) {
      enemyList.remove(enemyIndex);
      return false;
    }

    if (shootDelay == 0) {
      shootDelay = 8;
      bullets.add(new Bullet(x, y, playerX, playerY, 10));
    } else {
      shootDelay--;
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    if (dying > 10) {
      g.drawImage(moths[1], x - cameraX - 85, y - cameraY - 70, null);
    } else if (dying > 0) {
      g.drawImage(moths[2], x - cameraX - 85, y - cameraY - 70, null);
    } else {
      g.drawImage(moths[0], x - cameraX - 85, y - cameraY - 70, null);
    }
  }
}
