/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.awt.image.*;
import javax.imageio.*;
import java.awt.geom.*;
import java.io.*;

public class Main extends JFrame {

  private final boolean[] keys = new boolean[65535]; // pressed keys

  public static Random random = new Random();
  private static BufferedImage[] symbols = new BufferedImage[256];
  private BufferedImage greenBullet;
  private BufferedImage redBullet;
  public static BufferedImage firstAidKit;
  private BufferedImage[] backgrounds = new BufferedImage[23];
  private BufferedImage[] whiteBeatles = new BufferedImage[4];
  public static BufferedImage[] brownAnts = new BufferedImage[4];
  public static BufferedImage[] redAnts = new BufferedImage[4];
  public static BufferedImage[] blackAnts = new BufferedImage[4];
  public static BufferedImage[] fruitFlies = new BufferedImage[4];
  public static BufferedImage[] houseFlies = new BufferedImage[4];
  public static BufferedImage[] blowFlies = new BufferedImage[4];
  public static BufferedImage[] grubHeads = new BufferedImage[4];
  public static BufferedImage[] ladyBugs = new BufferedImage[2];
  public static BufferedImage[] fragments = new BufferedImage[4];
  public static BufferedImage[] moths = new BufferedImage[3];
  public static BufferedImage[] trapdoors = new BufferedImage[4];
  public static BufferedImage[] stinger = new BufferedImage[3];
  public static BufferedImage[] redStingers = new BufferedImage[3];
  public static BufferedImage[] rollers = new BufferedImage[16];
  public static BufferedImage[] bees = new BufferedImage[3];
  public static BufferedImage[] bossOnes = new BufferedImage[6];
  public static BufferedImage[] bossTwos = new BufferedImage[6];
  public static BufferedImage[] bossThrees = new BufferedImage[6];
  public static BufferedImage[] bossFours = new BufferedImage[4];
  public static BufferedImage[] bossFives = new BufferedImage[6];
  public static BufferedImage[] bossSixes = new BufferedImage[6];
  public static BufferedImage intro;
  public static BufferedImage ending;
  public static BufferedImage icon;

  public static int health = 1000;
  public static int score = 0;
  public static int dying = -1;
  
  private boolean[][] occupied;
  private static int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  public static ArrayList<IObject> objects;
  private ArrayList<Bullet> bullets;
  private int playerX;
  private int playerY;
  private int maxCameraX;
  private int maxCameraY;
  private int mouseX;
  private int mouseY;
  private int initialPlayerX;
  private int initialPlayerY;
  private boolean mousePressed;
  private boolean introMode = true;
  private static int endingMode = -1;
  private boolean paused;
  private int lowerY = Integer.MAX_VALUE;
  private static final AffineTransform transform = new AffineTransform();
  private static ArrayList<Coordinates>[] coordinates = new ArrayList[6];

  @SuppressWarnings("empty-statement")
  public void launch() throws Throwable {

    loadImages();
    loadStage();

    StringBuffer sb = new StringBuffer();
    BufferedImage image = new BufferedImage(
        640, 480, BufferedImage.TYPE_INT_RGB);
    Graphics2D g = (Graphics2D)image.getGraphics();

    enableEvents(AWTEvent.KEY_EVENT_MASK);

    JPanel panel = (JPanel)getContentPane();
    panel.setPreferredSize(new Dimension(640, 480));
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setIconImage(icon);
    setTitle("Bug Game");
    setResizable(false);
    pack();
    setLocationRelativeTo(null);
    setVisible(true);

    panel.addMouseListener(new MouseAdapter() {
      @Override
      public void mousePressed(MouseEvent e) {
        mousePressed = true;
        if (introMode) {
          introMode = false;
          endingMode = -1;
          dying = -1;
          health = 1000;
          score = 0;
          playerX = initialPlayerX;
          playerY = initialPlayerY;
          mousePressed = false;
          lowerY = Integer.MAX_VALUE;
        }
      }
    });
    panel.addMouseMotionListener(new MouseMotionAdapter() {
      @Override
      public void mouseMoved(MouseEvent e) {
        mouseX = e.getX();
        mouseY = e.getY();
      }
    });
    addFocusListener(new FocusListener() {
      @Override
      public void focusLost(FocusEvent e) {
        keys[KeyEvent.VK_W] = false;
        keys[KeyEvent.VK_D] = false;
        keys[KeyEvent.VK_S] = false;
        keys[KeyEvent.VK_A] = false;
        mousePressed = false;
        paused = true;
      }
      @Override
      public void focusGained(FocusEvent e) {
        paused = false;
      }
    });

    int playerWalkIndex = 0;
    int playerWalkSpriteIndex = 0;
    int walkIndex = 0;
    int walkSpriteIndex = 0;
    double playerAngle = 0;
    int cameraX = 0;
    int cameraY = 0;
    int playerSpriteX = 0;
    int playerSpriteY = 0;
    Bullet playerBullet = null;

    long nextFrameStart = System.nanoTime();
    outter: while(true) {

      if (introMode) {
        Graphics panelGraphics = panel.getGraphics();
        if (panelGraphics != null) {
          panelGraphics.drawImage(intro, 0, 0, null);
          panelGraphics.dispose();
        }
        Thread.sleep(10);
        nextFrameStart = System.nanoTime();
        continue;
      } else if (endingMode > 0) {
        if (--endingMode == 0) {
          endingMode = -1;
          loadStage();
          introMode = true;
          mousePressed = false;
          lowerY = Integer.MAX_VALUE;
          nextFrameStart = System.nanoTime();
          continue outter;
        }
        g.drawImage(ending, 0, 0, this);
        drawString(g, sb, score, 390, 75);
        Graphics panelGraphics = panel.getGraphics();
        if (panelGraphics != null) {
          panelGraphics.drawImage(image, 0, 0, null);
          panelGraphics.dispose();
        }
        Thread.sleep(10);
        nextFrameStart = System.nanoTime();
        continue;
      }

      do {
        nextFrameStart += 16666667;

        if (paused) {
          Thread.sleep(16);
          nextFrameStart = System.nanoTime();
          break;
        }

        walkSpriteIndex = ((++walkIndex) >> 4) & 1;

        if (dying >= 0) {
          if (--dying == 0) {
            dying = -1;
            endingMode = -1;
            loadStage();
            introMode = true;
            mousePressed = false;
            lowerY = Integer.MAX_VALUE;
            nextFrameStart = System.nanoTime();
            continue outter;
          }
          break;
        }

        int tileX = playerX >> 6;
        int tileY = playerY >> 6;
        int tile = backgroundTiles[tileY][tileX];
        boolean moved = false;
        if (keys[KeyEvent.VK_W]
            && backgroundTiles[(playerY - 36) >> 6][(playerX - 16) >> 6] < 19
            && backgroundTiles[(playerY - 36) >> 6][(playerX + 16) >> 6] < 19) {
          if (tile == 16) {
            playerY--;
          } else {
            playerY -= 4;
          }
          moved = true;
        }
        if (keys[KeyEvent.VK_S]
            && backgroundTiles[(playerY + 36) >> 6][(playerX - 16) >> 6] < 19
            && backgroundTiles[(playerY + 36) >> 6][(playerX + 16) >> 6] < 19
            && playerY < lowerY) {
          if (tile == 16) {
            playerY++;
          } else {
            playerY += 4;
          }
          moved = true;
        }
        if (keys[KeyEvent.VK_A]
            && backgroundTiles[(playerY - 16) >> 6][(playerX - 36) >> 6] < 19
            && backgroundTiles[(playerY + 16) >> 6][(playerX - 36) >> 6] < 19) {
          if (tile == 16) {
            playerX--;
          } else {
            playerX -= 4;
          }
          moved = true;
        }
        if (keys[KeyEvent.VK_D]
            && backgroundTiles[(playerY - 16) >> 6][(playerX + 36) >> 6] < 19
            && backgroundTiles[(playerY + 16) >> 6][(playerX + 36) >> 6] < 19) {
          if (tile == 16) {
            playerX++;
          } else {
            playerX += 4;
          }
          moved = true;
        }
        if (tile == 18) {
          playerY += 3;
        }
        if (moved) {
          playerWalkSpriteIndex = ((++playerWalkIndex) >> 4) & 1;
          if (tile == 17) {
            int tileY2 = playerY >> 6;
            if (tileY2 < tileY) {
              backgroundTiles[tileY][tileX] = 21;
            }
          }
        }

        cameraX = playerX - 320;
        cameraY = playerY - 240;
        if (cameraX > maxCameraX) {
          cameraX = maxCameraX;
        } else if (cameraX < 0) {
          cameraX = 0;
        }
        if (cameraY > lowerY - 448) {
          cameraY = lowerY - 448;
        } else if (cameraY > maxCameraY) {
          cameraY = maxCameraY;
        } else if (cameraY < 64) {
          cameraY = 64;
        }
        playerSpriteX = playerX - cameraX;
        playerSpriteY = playerY - cameraY;

        int dx = mouseX - playerSpriteX;
        int dy = mouseY - playerSpriteY;
        playerAngle = Math.PI + Math.atan2(dy, dx);
        if (mousePressed) {
          mousePressed = false;
          if (playerBullet == null) {
            playerBullet = new Bullet(
                playerX, playerY, playerX + dx, playerY + dy, 15);
          }
        }

        for(int b = bullets.size() - 1; b >= 0; b--) {
          Bullet bullet = bullets.get(b);
          double bx = playerX - bullet.x;
          double by = playerY - bullet.y;
          if (bx * bx + by * by < 725) {
            bullets.remove(b);
            Main.addHealth(-25);
          } else if (bullet.x < cameraX - 64 || bullet.y < cameraY - 64
              || bullet.x > cameraX + 704 || bullet.y > cameraY + 544
              || bullet.x >= 1280 || bullet.x < 0
              || bullet.y < 0
              || backgroundTiles[((int)bullet.y >> 6)][(int)bullet.x >> 6]
                  > 19) {
            bullets.remove(b);
          } else {
            bullet.x += bullet.vx;
            bullet.y += bullet.vy;
          }
        }
        if (playerBullet != null) {
          int bulletTile = backgroundTiles
              [(int)playerBullet.y >> 6][(int)playerBullet.x >> 6];
          if (playerBullet.x < cameraX - 16 || playerBullet.y < cameraY - 16
              || playerBullet.x > cameraX + 656
              || playerBullet.y > cameraY + 496
              || bulletTile > 18) {
            if (bulletTile == 20) {
              int X = (int)playerBullet.x >> 6;
              int Y = (int)playerBullet.y >> 6;
              new Fragments().init(null, null, null, null, X << 6, Y << 6);
              backgroundTiles[Y][X] = ((Y & 3) << 2) | (X & 3);
              score += 100;
            }
            playerBullet = null;
          } else {
            playerBullet.x += playerBullet.vx;
            playerBullet.y += playerBullet.vy;
          }
        }

        tileY = cameraY >> 6;
        for(int i = -1; i < 10; i++) {
          ArrayList<IObject> enemyList = enemies[i + tileY];
          for(int e = enemyList.size() - 1; e >= 0; e--) {
            IObject enemy = enemyList.get(e);
            enemy.prepareForUpdate();
          }
        }
        for(int i = -1; i < 10; i++) {
          ArrayList<IObject> enemyList = enemies[i + tileY];
          for(int e = enemyList.size() - 1; e >= 0; e--) {
            IObject enemy = enemyList.get(e);
            if (enemy.update(playerX, playerY, playerBullet,
                enemyList, e)) {
              playerBullet = null;
              score += 100;
            }
          }
        }
        for(int e = objects.size() - 1; e >= 0; e--) {
          IObject enemy = objects.get(e);
          if (enemy.update(playerX, playerY, playerBullet,
              objects, e)) {
            playerBullet = null;
            score += 100;
          }
        }

        int newLowerY = playerY + 960;
        if (newLowerY < lowerY && newLowerY - 448 < maxCameraY) {
          lowerY = newLowerY;
        }

      } while(nextFrameStart < System.nanoTime());

      int tileStartX = -(cameraX & 0x3F);
      int tileStartY = -(cameraY & 0x3F);
      int tileX = cameraX >> 6;
      int tileY = cameraY >> 6;
      for(int i = 0, y = tileStartY; i < 9; i++, y += 64) {
        for(int j = 0, x = tileStartX; j < 11; j++, x += 64) {
          int tile = backgroundTiles[i + tileY][j + tileX];
          if (tile == 18) {
            g.drawImage(rollers[(walkIndex >> 1) & 15], x, y, null);
          } else {
            g.drawImage(backgrounds[tile], x, y, null);
          }
        }
      }
      if (dying > 285) {
        drawSprite(g, playerAngle, playerSpriteX, playerSpriteY,
            whiteBeatles[2]);
      } else if (dying > 0) {
        drawSprite(g, playerAngle, playerSpriteX, playerSpriteY,
            whiteBeatles[3]);
      } else {
        drawSprite(g, playerAngle, playerSpriteX, playerSpriteY,
            whiteBeatles[playerWalkSpriteIndex]);
      }
      for(int i = -1; i < 10; i++) {
        ArrayList<IObject> enemyList = enemies[i + tileY];
        for(int e = enemyList.size() - 1; e >= 0; e--) {
          IObject enemy = enemyList.get(e);
          enemy.render(g, cameraX, cameraY, walkSpriteIndex);
        }
      }
      for(int e = objects.size() - 1; e >= 0; e--) {
        IObject enemy = objects.get(e);
        enemy.render(g, cameraX, cameraY, walkSpriteIndex);
      }

      for(int b = bullets.size() - 1; b >= 0; b--) {
        Bullet bullet = bullets.get(b);
        g.drawImage(redBullet,
            (int)(bullet.x - cameraX) - 8, (int)(bullet.y - cameraY) - 8, null);
      }
      if (playerBullet != null) {
        g.drawImage(greenBullet,
            (int)(playerBullet.x - cameraX) - 8,
            (int)(playerBullet.y - cameraY) - 8, null);
      }

      drawString(g, "H", 10, 425);
      drawString(g, "S", 10, 451);
      drawString(g, sb, health, 28, 425);
      drawString(g, sb, score, 28, 451);

      Graphics panelGraphics = panel.getGraphics();
      if (panelGraphics != null) {
        panelGraphics.drawImage(image, 0, 0, null);
        panelGraphics.dispose();
      }

      while(System.nanoTime() < nextFrameStart) {
        Thread.yield();
      }
    }
  }

  public static void drawString(Graphics2D g, StringBuffer sb,
      int number, int x, int y) {
    sb.setLength(0);
    do {
      sb.append((char)('0' + (number % 10)));
      number /= 10;
    } while(number > 0);
    for(int i = sb.length() - 1; i >= 0; i--, x += 18) {
      BufferedImage image = symbols[sb.charAt(i)];
      if (image != null) {
        g.drawImage(image, x, y, null);
      }
    }
  }

  public static void drawString(Graphics2D g, String string, int x, int y) {
    for(int i = 0; i < string.length(); i++, x += 18) {
      BufferedImage image = symbols[string.charAt(i)];
      if (image != null) {
        g.drawImage(image, x, y, null);
      }
    }
  }

  public static void addHealth(int value) {
    if (dying < 0) {
      health += value;
      if (health <= 0) {
        health = 0;
        dying = 300;
      }
    }
  }

  public static void convertCracked(int index) {
    if (dying < 0) {
      if (index == 5) {
        score += 50000;
        score += health * 10;
        endingMode = 1800;
      } else {
        score += 25000;
        ArrayList<Coordinates> locations = coordinates[index];
        for(int i = 0; i < locations.size(); i++) {
          Coordinates coordinate = locations.get(i);
          backgroundTiles[coordinate.y][coordinate.x] = 20;
        }
      }
    }
  }

  public static void drawSprite(Graphics2D g, 
      double angle, double x, double y, BufferedImage image) {

    double halfWidth = image.getWidth() >> 1;
    double halfHeight = image.getHeight() >> 1;

    transform.setToIdentity();
    transform.translate(x - halfWidth, y - halfHeight);
    transform.rotate(angle, halfWidth, halfHeight);

    g.drawImage(image, transform, null);
  }

  private void loadStage() throws Throwable {

    BossOne.count = 0;
    BossThree.count = 0;
    BossFour.count = 0;
    BossFive.count = 0;

    BufferedReader br = new BufferedReader(new InputStreamReader(
        Main.class.getClassLoader().getResource(
            "stages/stage.txt").openStream()));
    String input = null;
    ArrayList<String> lines = new ArrayList<String>();
    while((input = br.readLine()) != null) {
      lines.add(input);
    }
    br.close();

    int width = lines.get(0).length();
    int height = lines.size();
    maxCameraX = 64 * width - 641;
    maxCameraY = 64 * height - 513;

    backgroundTiles = new int[height + 1][width];
    occupied = new boolean[(height + 1) << 1][width << 1];
    objects = new ArrayList<IObject>();
    enemies = new ArrayList[height + 1];
    for(int i = 0; i < height + 1; i++) {
      enemies[i] = new ArrayList<IObject>();
    }
    bullets = new ArrayList<Bullet>();
    
    for(int i = 0; i < coordinates.length; i++) {
      coordinates[i] = new ArrayList<Coordinates>();
    }

    for(int y = 0; y < height; y++) {
      String line = lines.get(y);
      for(int x = 0; x < width; x++) {
        char c = line.charAt(x);
        switch(c) {
          case '.':
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            break;
          case '*':
            initialPlayerX = playerX = 32 + 64 * x;
            initialPlayerY = playerY = 32 + 64 * y;
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            break;
          case '+': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            new FirstAidKit().init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }            
          case 'X':
            backgroundTiles[y][x] = 21;
            break;
          case 'A':
            backgroundTiles[y][x] = 16;
            break;
          case 'B':
            backgroundTiles[y][x] = 18;
            break;
          case 'C':
            backgroundTiles[y][x] = 17;
            break;
          case 'Y':
            backgroundTiles[y][x] = 19;
            break;
          case 'Z':
            backgroundTiles[y][x] = 20;
            break;
          case '0':
            backgroundTiles[y][x] = 22;
            coordinates[0].add(new Coordinates(x, y));
            break;
          case '1':
            backgroundTiles[y][x] = 22;
            coordinates[1].add(new Coordinates(x, y));
            break;
          case '2':
            backgroundTiles[y][x] = 22;
            coordinates[2].add(new Coordinates(x, y));
            break;
          case '3':
            backgroundTiles[y][x] = 22;
            coordinates[3].add(new Coordinates(x, y));
            break;
          case '4':
            backgroundTiles[y][x] = 22;
            coordinates[4].add(new Coordinates(x, y));
            break;
          case '5':
            backgroundTiles[y][x] = 22;
            coordinates[5].add(new Coordinates(x, y));
            break;
          case 'a': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BrownAnt brownAnt = new BrownAnt();
            brownAnt.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'b': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            RedAnt redAnt = new RedAnt();
            redAnt.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'c': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BlackAnt blackAnt = new BlackAnt();
            blackAnt.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'd': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            FruitFly fruitFly = new FruitFly();
            fruitFly.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'e': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            HouseFly houseFly = new HouseFly();
            houseFly.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'f': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BlowFly blowFly = new BlowFly();
            blowFly.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'g': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            GrubHead grubHead = new GrubHead();
            grubHead.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'h': {
            backgroundTiles[y][x] = 19;
            LadyBug ladyBug = new LadyBug();
            ladyBug.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'i': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            Moth moth = new Moth();
            moth.init(occupied, backgroundTiles, enemies, bullets,
                64 * x, 64 * y);
            break;
          }
          case 'j': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            TrapdoorSpider trapdoorSpider = new TrapdoorSpider();
            trapdoorSpider.init(occupied, backgroundTiles, enemies, bullets,
                64 * x, 64 * y);
            break;
          }
          case 'k': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            new Stinger(0).init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'l': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            new Stinger(1).init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'm': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            new Stinger(2).init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'n': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            new Stinger(3).init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }

          case 'o': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            RedStinger redStinger = new RedStinger(0);
            redStinger.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'p': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            RedStinger redStinger = new RedStinger(1);
            redStinger.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'q': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            RedStinger redStinger = new RedStinger(2);
            redStinger.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 'r': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            RedStinger redStinger = new RedStinger(3);
            redStinger.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 's': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            Bee bee = new Bee();
            bee.init(occupied, backgroundTiles, enemies, bullets,
                32 + 64 * x, 32 + 64 * y);
            break;
          }
          case 't': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BossOne bossOne = new BossOne();
            bossOne.init(occupied, backgroundTiles, enemies, bullets,
                64 + 64 * x, 57 + 64 * y);
            break;
          }
          case 'u': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BossTwo bossTwo = new BossTwo();
            bossTwo.init(occupied, backgroundTiles, enemies, bullets,
                64 + 64 * x, 60 + 64 * y);
            break;
          }
          case 'v': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BossThree bossThree = new BossThree();
            bossThree.init(occupied, backgroundTiles, enemies, bullets,
                64 + 64 * x, 45 + 64 * y);
            break;
          }
          case 'w': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BossFour bossFour = new BossFour();
            bossFour.init(occupied, backgroundTiles, enemies, bullets,
                131 + 64 * x, 145 + 64 * y);
            break;
          }
          case 'x': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BossFive bossFive = new BossFive();
            bossFive.init(occupied, backgroundTiles, enemies, bullets,
                64 + 64 * x, 56 + 64 * y);
            break;
          }
          case 'y': {
            backgroundTiles[y][x] = ((y & 3) << 2) | (x & 3);
            BossSix bossSix = new BossSix();
            bossSix.init(occupied, backgroundTiles, enemies, bullets,
                 74 + 64 * x, 128 + 64 * y);
            break;
          }
        }
      }
    }
  }

  private void loadImages() throws Throwable {

    icon = loadImage("application_icon.png");

    backgrounds[16] = loadImage("grate.png");
    backgrounds[17] = loadImage("sandy_brick.png");
    // 18 = roller
    backgrounds[19] = loadImage("plant.png");
    backgrounds[20] = loadImage("cracked_brick.png");
    backgrounds[21] = loadImage("brick.png");
    backgrounds[22] = loadImage("cracked_blue.png");

    firstAidKit = loadImage("first_aid_kit.png");
    greenBullet = loadImage("green_bullet.png");
    redBullet = loadImage("red_bullet.png");
    whiteBeatles[0] = loadImage("white_beatle_1.png");
    whiteBeatles[1] = loadImage("white_beatle_2.png");
    whiteBeatles[2] = loadImage("white_beatle_3.png");
    whiteBeatles[3] = loadImage("white_beatle_4.png");
    brownAnts[0] = loadImage("brown_ant_1.png");
    brownAnts[1] = loadImage("brown_ant_2.png");
    brownAnts[2] = loadImage("brown_ant_3.png");
    brownAnts[3] = loadImage("brown_ant_4.png");
    redAnts[0] = loadImage("red_ant_1.png");
    redAnts[1] = loadImage("red_ant_2.png");
    redAnts[2] = loadImage("red_ant_3.png");
    redAnts[3] = loadImage("red_ant_4.png");
    blackAnts[0] = loadImage("black_ant_1.png");
    blackAnts[1] = loadImage("black_ant_2.png");
    blackAnts[2] = loadImage("black_ant_3.png");
    blackAnts[3] = loadImage("black_ant_4.png");
    fruitFlies[0] = loadImage("fruit_fly_1.png");
    fruitFlies[1] = loadImage("fruit_fly_2.png");
    fruitFlies[2] = loadImage("fruit_fly_3.png");
    fruitFlies[3] = loadImage("fruit_fly_4.png");
    houseFlies[0] = loadImage("house_fly_1.png");
    houseFlies[1] = loadImage("house_fly_2.png");
    houseFlies[2] = loadImage("house_fly_3.png");
    houseFlies[3] = loadImage("house_fly_4.png");
    blowFlies[0] = loadImage("blow_fly_1.png");
    blowFlies[1] = loadImage("blow_fly_2.png");
    blowFlies[2] = loadImage("blow_fly_3.png");
    blowFlies[3] = loadImage("blow_fly_4.png");
    grubHeads[0] = loadImage("grub_head_1.png");
    grubHeads[1] = loadImage("grub_head_2.png");
    grubHeads[2] = loadImage("grub_head_3.png");
    grubHeads[3] = loadImage("grub_head_4.png");
    ladyBugs[0] = loadImage("lady_bug_1.png");
    ladyBugs[1] = loadImage("lady_bug_2.png");
    fragments[0] = loadImage("fragment_1.png");
    fragments[1] = loadImage("fragment_2.png");
    fragments[2] = loadImage("fragment_3.png");
    fragments[3] = loadImage("fragment_4.png");  
    moths[0] = loadImage("moth_1.png");
    moths[1] = loadImage("moth_2.png");
    moths[2] = loadImage("moth_3.png");
    trapdoors[0] = loadImage("trapdoor_1.png");
    trapdoors[1] = loadImage("trapdoor_2.png");
    trapdoors[2] = loadImage("trapdoor_3.png");
    trapdoors[3] = loadImage("trapdoor_4.png");
    stinger[0] = loadImage("stinger_1.png");
    stinger[1] = loadImage("stinger_2.png");
    stinger[2] = loadImage("stinger_3.png");
    redStingers[0] = loadImage("red_stinger_1.png");
    redStingers[1] = loadImage("red_stinger_2.png");
    redStingers[2] = loadImage("red_stinger_3.png");
    bees[0] = loadImage("bee_1.png");
    bees[1] = loadImage("bee_2.png");
    bees[2] = loadImage("bee_3.png");
    bossOnes[0] = loadImage("boss_one_1.png");
    bossOnes[1] = loadImage("boss_one_2.png");
    bossOnes[2] = loadImage("boss_one_3.png");
    bossOnes[3] = loadImage("boss_one_4.png");
    bossOnes[4] = loadImage("boss_one_5.png");
    bossOnes[5] = loadImage("boss_one_6.png");
    bossTwos[0] = loadImage("boss_two_1.png");
    bossTwos[1] = loadImage("boss_two_2.png");
    bossTwos[2] = loadImage("boss_two_3.png");
    bossTwos[3] = loadImage("boss_two_4.png");
    bossTwos[4] = loadImage("boss_two_5.png");
    bossTwos[5] = loadImage("boss_two_6.png");
    bossThrees[0] = loadImage("boss_three_1.png");
    bossThrees[1] = loadImage("boss_three_2.png");
    bossThrees[2] = loadImage("boss_three_3.png");
    bossThrees[3] = loadImage("boss_three_4.png");
    bossThrees[4] = loadImage("boss_three_5.png");
    bossThrees[5] = loadImage("boss_three_6.png");
    bossFours[0] = loadImage("boss_four_1.png");
    bossFours[1] = loadImage("boss_four_2.png");
    bossFours[2] = loadImage("boss_four_3.png");
    bossFours[3] = loadImage("boss_four_4.png");
    bossFives[0] = loadImage("boss_five_1.png");
    bossFives[1] = loadImage("boss_five_2.png");
    bossFives[2] = loadImage("boss_five_3.png");
    bossFives[3] = loadImage("boss_five_4.png");
    bossFives[4] = loadImage("boss_five_5.png");
    bossFives[5] = loadImage("boss_five_6.png");
    bossSixes[0] = loadImage("boss_six_1.png");
    bossSixes[1] = loadImage("boss_six_2.png");
    bossSixes[2] = loadImage("boss_six_3.png");
    bossSixes[3] = loadImage("boss_six_4.png");
    bossSixes[4] = loadImage("boss_six_5.png");
    bossSixes[5] = loadImage("boss_six_6.png");

    BufferedImage roller = loadImage("roller.png");
    for(int i = 0; i < 16; i++) {
      rollers[i] = new BufferedImage(64, 64, BufferedImage.TYPE_INT_RGB);
      Graphics g = rollers[i].createGraphics();
      g.drawImage(roller, 0, i * 4, rootPane);
      g.drawImage(roller, 0, i * 4 - 64, rootPane);
      g.dispose();
    }

    BufferedImage sandImage = loadImage("sand.png");
    for(int i = 0; i < 4; i++) {
      for(int j = 0; j < 4; j++) {
        BufferedImage image = new BufferedImage(
            64, 64, BufferedImage.TYPE_INT_RGB);
        Graphics g = image.createGraphics();
        g.drawImage(sandImage, -(j << 6), -(i << 6), null);
        g.dispose();
        backgrounds[(i << 2) | j] = image;
      }
    }

    BufferedImage symbolsImage = loadImage("symbols.png");
    String str = "ABCDEFGHIJKLM";
    for(int i = 0; i < str.length(); i++) {
      char c = str.charAt(i);
      BufferedImage image = new BufferedImage(
          20, 23, BufferedImage.TYPE_4BYTE_ABGR_PRE);
      symbols[c] = image;
      Graphics g = image.createGraphics();
      g.drawImage(symbolsImage, -10 - i * 28, -12, null);
      g.dispose();
    }

    str = "NOPQRSTUVWXYZ";
    for(int i = 0; i < str.length(); i++) {
      char c = str.charAt(i);
      BufferedImage image = new BufferedImage(
          20, 23, BufferedImage.TYPE_4BYTE_ABGR_PRE);
      symbols[c] = image;
      Graphics g = image.createGraphics();
      g.drawImage(symbolsImage, -10 - i * 28, -39, null);
      g.dispose();
    }

    str = "0123456789-*&";
    for(int i = 0; i < str.length(); i++) {
      char c = str.charAt(i);
      BufferedImage image = new BufferedImage(
          20, 23, BufferedImage.TYPE_4BYTE_ABGR_PRE);
      symbols[c] = image;
      Graphics g = image.createGraphics();
      g.drawImage(symbolsImage, -10 - i * 28, -66, null);
      g.dispose();
    }

    str = ".!?,\"'`/\\|:;#";
    for(int i = 0; i < str.length(); i++) {
      char c = str.charAt(i);
      BufferedImage image = new BufferedImage(
          20, 23, BufferedImage.TYPE_4BYTE_ABGR_PRE);
      symbols[c] = image;
      Graphics g = image.createGraphics();
      g.drawImage(symbolsImage, -10 - i * 28, -93, null);
      g.dispose();
    }

    intro = loadImage("intro.png");
    ending = loadImage("ending.png");
  }

  @Override
  protected void processKeyEvent(KeyEvent e) {
    keys[e.getKeyCode()] = e.getID() == 401;
  }

  private BufferedImage loadImage(String name) throws Throwable {
    return ImageIO.read(Main.class.getClassLoader().getResource(
        "images/" + name));
  }

  public static void main(String[] args) throws Throwable {
    Main main = new Main();
    main.launch();
  }

}
