/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class LadyBug implements IObject {

  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage[] ladyBugs;
  private int x;
  private int y;
  private double angle;
  private boolean updated;
  private int shootDelay;

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.ladyBugs = Main.ladyBugs;
    this.x = x;
    this.y = y;

    shootDelay = Main.random.nextInt(90);

    occupied[(y >> 5) - 1][(x >> 5) - 1] = true;
    occupied[(y >> 5) - 1][(x >> 5)] = true;
    occupied[(y >> 5)][(x >> 5) - 1] = true;
    occupied[(y >> 5)][(x >> 5)] = true;

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
    updated = false;
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (updated) {
      return false;
    } else {
      updated = true;
    }

    double dx = playerX - x;
    double dy = playerY - y;
    if (dx * dx + dy * dy < 4096) {
      Main.addHealth(-1);
    }
    angle = Math.atan2(dy, dx);

    int X = x >> 5;
    int Y = y >> 5;

    occupied[Y - 1][X - 1] = false;
    occupied[Y - 1][X] = false;
    occupied[Y][X - 1] = false;
    occupied[Y][X] = false;

    int x2 = x;
    int y2 = y;

    if (dx < 0) {
      if (backgroundTiles[(y2 - 16) >> 6][(x2 - 33) >> 6] == 19
          && backgroundTiles[(y2 + 16) >> 6][(x2 - 33) >> 6] == 19) {
        x2--;
      }
    } else if (dx > 0) {
      if (backgroundTiles[(y2 - 16) >> 6][(x2 + 33) >> 6] == 19
          && backgroundTiles[(y2 + 16) >> 6][(x2 + 33) >> 6] == 19) {
        x2++;
      }
    }
    if (dy < 0) {
      if (backgroundTiles[(y2 - 33) >> 6][(x2 - 16) >> 6] == 19
          && backgroundTiles[(y2 - 33) >> 6][(x2 + 16) >> 6] == 19) {
        y2--;
      }
    } else if (dy > 0) {
      if (backgroundTiles[(y2 + 33) >> 6][(x2 - 16) >> 6] == 19
          && backgroundTiles[(y2 + 33) >> 6][(x2 + 16) >> 6] == 19) {
        y2++;
      }
    }

    X = x2 >> 5;
    Y = y2 >> 5;

    if (!occupied[Y - 1][X - 1]
        && !occupied[Y - 1][X]
        && !occupied[Y][X - 1]
        && !occupied[Y][X]) {

      int e1 = y >> 6;
      int e2 = y2 >> 6;
      if (e1 != e2) {
        enemyList.remove(enemyIndex);
        enemies[e2].add(this);
      }

      x = x2;
      y = y2;
    } else {
      int x3 = x2;
      x2 = x;
      X = x2 >> 5;

      if (!occupied[Y - 1][X - 1]
        && !occupied[Y - 1][X]
        && !occupied[Y][X - 1]
        && !occupied[Y][X]) {

        int e1 = y >> 6;
        int e2 = y2 >> 6;
        if (e1 != e2) {
          enemyList.remove(enemyIndex);
          enemies[e2].add(this);
        }

        x = x2;
        y = y2;
      } else {
        x2 = x3;
        y2 = y;

        X = x2 >> 5;
        Y = y2 >> 5;

        if (!occupied[Y - 1][X - 1]
          && !occupied[Y - 1][X]
          && !occupied[Y][X - 1]
          && !occupied[Y][X]) {

          int e1 = y >> 6;
          int e2 = y2 >> 6;
          if (e1 != e2) {
            enemyList.remove(enemyIndex);
            enemies[e2].add(this);
          }

          x = x2;
          y = y2;
        } else {
          X = x >> 5;
          Y = y >> 5;
        }
      }
    }

    occupied[Y - 1][X - 1] = true;
    occupied[Y - 1][X] = true;
    occupied[Y][X - 1] = true;
    occupied[Y][X] = true;

    if (shootDelay == 0) {
      shootDelay = 90;
      bullets.add(new Bullet(x, y, playerX, playerY, 5));
    } else {
      shootDelay--;
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    Main.drawSprite(g, angle, x - cameraX, y - cameraY,
        ladyBugs[walkSpriteIndex]);
  }
}
