/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class Fragments implements IObject {

  private BufferedImage[] fragments;
  private int moves = 8;
  private int[] xs = new int[4];
  private int[] ys = new int[4];

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.fragments = Main.fragments;

    xs[0] = x;
    xs[1] = 28 + x;
    xs[2] = x;
    xs[3] = 29 + x;

    ys[0] = y;
    ys[1] = y;
    ys[2] = 29 + y;
    ys[3] = 25 + y;

    //  g.drawImage(fragments[0], 0, 0, null);
    //  g.drawImage(fragments[1], 28, 0, null);
    //  g.drawImage(fragments[2], 0, 29, null);
    //  g.drawImage(fragments[3], 29, 25, null);

    Main.objects.add(this);
  }

  public void prepareForUpdate() {
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (--moves == 0) {
      enemyList.remove(enemyIndex);
    } else {
      xs[0] -= 5;
      ys[0] -= 5;
      xs[1] += 5;
      ys[1] -= 5;
      xs[2] -= 5;
      ys[2] += 5;
      xs[3] += 5;
      ys[3] += 5;
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    g.drawImage(fragments[0], xs[0] - cameraX, ys[0] - cameraY, null);
    g.drawImage(fragments[1], xs[1] - cameraX, ys[1] - cameraY, null);
    g.drawImage(fragments[2], xs[2] - cameraX, ys[2] - cameraY, null);
    g.drawImage(fragments[3], xs[3] - cameraX, ys[3] - cameraY, null);
  }
}
