/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class FirstAidKit implements IObject {

  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage firstAidKit;
  private int x;
  private int y;
  private boolean updated;

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.firstAidKit = Main.firstAidKit;
    this.x = x;
    this.y = y;

    occupied[(y >> 5) - 1][(x >> 5) - 1] = true;
    occupied[(y >> 5) - 1][(x >> 5)] = true;
    occupied[(y >> 5)][(x >> 5) - 1] = true;
    occupied[(y >> 5)][(x >> 5)] = true;

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
    updated = false;
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (updated) {
      return false;
    } else {
      updated = true;
    }

    double dx = playerX - x;
    double dy = playerY - y;
    if (dx * dx + dy * dy < 2304) {
      Main.addHealth(250);

      int X = x >> 5;
      int Y = y >> 5;

      occupied[Y - 1][X - 1] = false;
      occupied[Y - 1][X] = false;
      occupied[Y][X - 1] = false;
      occupied[Y][X] = false;

      enemyList.remove(enemyIndex);
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    g.drawImage(firstAidKit, x - cameraX - 16, y - cameraY - 16, null);
  }

  public boolean playerHit(int playerX, int playerY) {
    return false;
  }
}
