/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class BossThree implements IObject {

  public static int count;
  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage[] bossThrees;
  private int x;
  private int y;
  private double angle;
  private boolean updated;
  private int dying = -1;
  private int shootDelay;
  private int hits = 5;
  private int sleeping;
  private int stunned = 0;

  public BossThree() {
    count++;
  }

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.bossThrees = Main.bossThrees;
    this.x = x;
    this.y = y;

    shootDelay = Main.random.nextInt(90);

    for(int i = -2; i <= 2; i++) {
      for(int j = -2; j <= 2; j++) {
        occupied[(y >> 5) + i][(x >> 5) + j] = true;
      }
    }

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
    updated = false;
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (updated) {
      return false;
    } else {
      updated = true;
    }

    if (dying > 0) {
      dying--;
      if (dying == 0) {
        int X = x >> 5;
        int Y = y >> 5;

        for(int i = -2; i <= 2; i++) {
          for(int j = -2; j <= 2; j++) {
            occupied[Y + i][X + j] = false;
          }
        }

        enemyList.remove(enemyIndex);

        if (--count == 0) {
          Main.convertCracked(2);
        }
      }
      return false;
    }

    if (stunned > 0) {
      stunned--;
    }

    if (playerBullet != null) {
      double bx = playerBullet.x - x;
      double by = playerBullet.y - y;
      if (bx * bx + by * by <= 1024 && stunned == 0) {
        if (--hits == 0) {
          dying = 15;
        } else {
          stunned = 20;
        }
        return true;
      }
    }

    double dx = playerX - x;
    double dy = playerY - y;
    if (dx * dx + dy * dy < 4096) {
      Main.addHealth(-1);
    }
    angle = Math.atan2(dy, dx);

    int X = x >> 5;
    int Y = y >> 5;

    for(int i = -2; i <= 2; i++) {
      for(int j = -2; j <= 2; j++) {
        occupied[Y + i][X + j] = false;
      }
    }

    int x2 = x;
    int y2 = y;

    if (dx < 0) {
      if (backgroundTiles[(y2 - 32) >> 6][(x2 - 34) >> 6] < 17
          && backgroundTiles[(y2 + 32) >> 6][(x2 - 34) >> 6] < 17) {
        x2 -= 2;
      }
    } else if (dx > 0) {
      if (backgroundTiles[(y2 - 32) >> 6][(x2 + 34) >> 6] < 17
          && backgroundTiles[(y2 + 32) >> 6][(x2 + 34) >> 6] < 17) {
        x2 += 2;
      }
    }
    if (dy < 0) {
      if (backgroundTiles[(y2 - 34) >> 6][(x2 - 32) >> 6] < 17
          && backgroundTiles[(y2 - 34) >> 6][(x2 + 32) >> 6] < 17) {
        y2 -= 2;
      }
    } else if (dy > 0) {
      if (backgroundTiles[(y2 + 34) >> 6][(x2 - 32) >> 6] < 17
          && backgroundTiles[(y2 + 34) >> 6][(x2 + 32) >> 6] < 17) {
        y2 += 2;
      }
    }

    X = x2 >> 5;
    Y = y2 >> 5;

    boolean occup = false;
    outter: for(int i = -2; i <= 2; i++) {
      for(int j = -2; j <= 2; j++) {
        if (occupied[Y + i][X + j]) {
          occup = true;
          break outter;
        }
      }
    }

    if (!occup) {

      int e1 = y >> 6;
      int e2 = y2 >> 6;
      if (e1 != e2) {
        enemyList.remove(enemyIndex);
        enemies[e2].add(this);
      }

      x = x2;
      y = y2;
    } else {
      int x3 = x2;
      x2 = x;
      X = x2 >> 5;

      occup = false;
      outter: for(int i = -2; i <= 2; i++) {
        for(int j = -2; j <= 2; j++) {
          if (occupied[Y + i][X + j]) {
            occup = true;
            break outter;
          }
        }
      }

      if (!occup) {

        int e1 = y >> 6;
        int e2 = y2 >> 6;
        if (e1 != e2) {
          enemyList.remove(enemyIndex);
          enemies[e2].add(this);
        }

        x = x2;
        y = y2;
      } else {
        x2 = x3;
        y2 = y;

        X = x2 >> 5;
        Y = y2 >> 5;

        occup = false;
        outter: for(int i = -2; i <= 2; i++) {
          for(int j = -2; j <= 2; j++) {
            if (occupied[Y + i][X + j]) {
              occup = true;
              break outter;
            }
          }
        }

        if (!occup) {

          int e1 = y >> 6;
          int e2 = y2 >> 6;
          if (e1 != e2) {
            enemyList.remove(enemyIndex);
            enemies[e2].add(this);
          }

          x = x2;
          y = y2;
        } else {
          X = x >> 5;
          Y = y >> 5;
        }
      }
    }

    for(int i = -2; i <= 2; i++) {
      for(int j = -2; j <= 2; j++) {
        occupied[Y + i][X + j] = true;
      }
    }

    if (--sleeping <= 0) {
      if (shootDelay == 0) {
        shootDelay = 5;
        bullets.add(new Bullet(x, y, playerX, playerY, 5));
      } else {
        shootDelay--;
      }
      if (sleeping < -60) {
        sleeping = 120;
      }
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    if (dying > 10) {
      Main.drawSprite(g, angle, x - cameraX, y - cameraY,
          bossThrees[4]);
    } else if (dying > 0) {
      Main.drawSprite(g, angle, x - cameraX, y - cameraY,
          bossThrees[5]);
    } else {
      if (stunned > 0) {
        walkSpriteIndex += 2;
      }
      Main.drawSprite(g, angle, x - cameraX, y - cameraY,
          bossThrees[walkSpriteIndex]);
    }
  }
}
