/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class BossFour implements IObject {

  public static int count;
  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage[] bossFours;
  private int x;
  private int y;
  private int dying = -1;
  private int shootDelay;
  private int hits = 15;
  private int stunned = 0;
  private double angle;
  private double angle2;
  private int Y;

  public BossFour() {
    count++;
  }

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.bossFours = Main.bossFours;
    this.x = x;
    this.Y = this.y = y;

    shootDelay = Main.random.nextInt(90);

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (enemyList != Main.objects) {
      enemyList.remove(enemyIndex);
      Main.objects.add(this);
      enemyList = Main.objects;
      enemyIndex = enemyList.size() - 1;
    }

    if (dying > 0) {
      dying--;
      if (dying == 0) {

        enemyList.remove(enemyIndex);

        if (--count == 0) {
          Main.convertCracked(3);
        }
      }
      return false;
    }

    if (stunned > 0) {
      stunned--;
    }

    angle += 0.012;
    angle2 += 0.03;
    x = (int)(playerX + 256 * Math.sin(angle));
    if (x < 256) {
      x = 256;
    } else if (x > 1024) {
      x = 1024;
    }
    y = (int)(Y + 64 * Math.cos(angle2));

    if (playerBullet != null) {
      double bx = playerBullet.x - x;
      double by = playerBullet.y - y;
      if (bx * bx + by * by <= 1024 && stunned == 0) {
        if (--hits == 0) {
          dying = 15;
        } else {
          stunned = 10;
        }
        return true;
      }
    }

    double dx = playerX - x;
    double dy = playerY - y;
    if (dx * dx + dy * dy < 4096) {
      Main.addHealth(-1);
    }

    if (shootDelay == 0) {
      shootDelay = 120;
      if (!occupied[(y >> 5) - 1][(x >> 5) - 1]
          && !occupied[(y >> 5) - 1][(x >> 5)]
          && !occupied[(y >> 5)][(x >> 5) - 1]
          && !occupied[(y >> 5)][(x >> 5)]) {
        switch(Main.random.nextInt(3)) {
          case 0:
            new BlowFly().init(
                occupied, backgroundTiles, enemies, bullets, x, y);
            break;
          case 1:
            new FruitFly().init(
                occupied, backgroundTiles, enemies, bullets, x, y);
            break;
          case 2:
            new HouseFly().init(
                occupied, backgroundTiles, enemies, bullets, x, y);
            break;
        }        
      }
    } else {
      shootDelay--;
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    if (dying > 10) {
      g.drawImage(bossFours[2],  x - cameraX - 131, y - cameraY - 145, null);
    } else if (dying > 0) {
      g.drawImage(bossFours[3],  x - cameraX - 131, y - cameraY - 145, null);
    } else if (stunned > 0) {
      g.drawImage(bossFours[1],  x - cameraX - 131, y - cameraY - 145, null);
    } else {
      g.drawImage(bossFours[0],  x - cameraX - 131, y - cameraY - 145, null);
    }
  }
}
