/*
 * Bug Game
 * Copyright (C) 2009 meatfighter.com
 *
 * This file is part of Bug Game
 *
 * Bug Game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bug Game is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package entomos;

import java.awt.*;
import java.util.*;
import java.awt.image.*;

public class Bee implements IObject {

  private static final double HALF_PI = Math.PI / 2;

  private boolean[][] occupied;
  private int[][] backgroundTiles;
  private ArrayList<IObject>[] enemies;
  private ArrayList<Bullet> bullets;
  private BufferedImage[] bees;
  private int x;
  private int y;
  private int shootDelay;
  private int dying = -1;
  private double angle;
  private double radius;

  public void init(boolean[][] occupied, int[][] backgroundTiles,
      ArrayList<IObject>[] enemies, ArrayList<Bullet> bullets,
      int x, int y) {
    this.occupied = occupied;
    this.backgroundTiles = backgroundTiles;
    this.enemies = enemies;
    this.bullets = bullets;
    this.bees = Main.bees;
    this.x = x;
    this.y = y;

    enemies[y >> 6].add(this);
  }

  public void prepareForUpdate() {
  }

  public boolean update(int playerX, int playerY, Bullet playerBullet,
      ArrayList<IObject> enemyList, int enemyIndex) {

    if (enemyList != Main.objects) {
      enemyList.remove(enemyIndex);
      Main.objects.add(this);
      enemyList = Main.objects;
      enemyIndex = enemyList.size() - 1;

      double dx = x - playerX;
      double dy = y - playerY;
      angle = Math.atan2(dy, dx);
      radius = Math.sqrt(dx * dx + dy * dy);
    }

    x = (int)(playerX + radius * Math.cos(angle));
    y = (int)(playerY + radius * Math.sin(angle));
    angle += 0.04;
    if (radius > 0.2) {
      radius -= 0.2;
    }

    if (dying > 0) {
      dying--;
      if (dying == 0) {
        enemyList.remove(enemyIndex);
      }
      return false;
    }

    if (playerBullet != null) {
      double bx = playerBullet.x - x;
      double by = playerBullet.y - y;
      if (bx * bx + by * by <= 1024) {
        dying = 15;
        return true;
      }
    }

    if (shootDelay == 0) {
      shootDelay = 90;
      bullets.add(new Bullet(x, y, playerX, playerY, 10));
    } else {
      shootDelay--;
    }

    return false;
  }

  public void render(Graphics2D g, int cameraX, int cameraY,
      int walkSpriteIndex) {
    if (dying > 10) {
      Main.drawSprite(g, angle + HALF_PI, x - cameraX, y - cameraY,
          bees[1]);
    } else if (dying > 0) {
      Main.drawSprite(g, angle + HALF_PI, x - cameraX, y - cameraY,
          bees[2]);
    } else {
      Main.drawSprite(g, angle + HALF_PI, x - cameraX, y - cameraY,
          bees[0]);
    }
  }
}
